/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.base.vpdmgr.VpdConfigurationData;
import com.ibm.hwmca.base.vpdmgr.VpdData;
import com.ibm.hwmca.base.vpdmgr.VpdManager;
import com.ibm.hwmca.base.vpdmgr.VpdManagerException;
import com.ibm.hwmca.base.vpdmgr.VpdRequestValue;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.attn.Attention;
import com.ibm.hwmca.fw.attn.AttentionID;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.schedops.HMCScheduler;
import com.ibm.hwmca.fw.schedops.OperationTarget;
import com.ibm.hwmca.fw.schedops.SchedulableConfigManager;
import com.ibm.hwmca.fw.schedops.Scheduler;
import com.ibm.hwmca.fw.settings.network.NetworkSettingsChangedEvent;
import com.ibm.hwmca.fw.settings.network.NetworkSettingsChangedEventListener;
import com.ibm.hwmca.fw.settings.network.NetworkSettingsChangedManager;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.updates.LiccEnabled;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HMC
extends ManagedObject
implements OperationTarget,
PropertyChangeListener,
NetworkSettingsChangedEventListener {
    private static final String CLASS_NAME = "[HMC] ";
    private static final String TRACE_MASKT = "XHMCxxxT";
    private static final String TRACE_MASKF = "XHMCxxxF";
    private static final String TRACE_MASKD = "XHMCxxxD";
    private static HMC INSTANCE;
    private static final int VPD_MACHINE_TYPE = 1;
    private static final int VPD_MACHINE_MODEL = 2;
    private static final int VPD_MACHINE_SERIAL = 3;
    private static final int VPD_CACHE_MTMS = 0;
    private String machineType = null;
    private String machineModel = null;
    private String machineSerial = null;
    private boolean bCacheMtms = false;
    private static Object initializeLock;
    private static Collection schedulables;
    private PersistenceManager pm = PersistenceManager.getPersistenceManager();
    private String persistenceNameSpace;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$updates$LiccEnabled;

    private HMC() {
        Trace.trace(TRACE_MASKT, "[HMC] <> HMC() : " + this.getObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HMC getHMC() {
        Object object = initializeLock;
        synchronized (object) {
            if (INSTANCE == null) {
                Trace.trace(TRACE_MASKT, "[HMC] >> getHMC()");
                INSTANCE = new HMC();
                HMC.INSTANCE.root = true;
                HMC.INSTANCE.locked = false;
                Object name = null;
                NetworkSettings networkSettings = NetworkSettings.getNetworkSettings();
                List networkInterfaces = networkSettings.getNetworkInterfaceInfo();
                ObjectId id = INSTANCE.getObjectId();
                INSTANCE.setObjectId(id);
                HMC.INSTANCE.persistenceNameSpace = INSTANCE.getClass().getName();
                INSTANCE.addPropertyChangeListener("AttentionsExist", INSTANCE);
                INSTANCE.readAllPersistedAttentions();
                String className = INSTANCE.getClass().getName();
                schedulables = SchedulableConfigManager.getSchedulableDescriptors(className);
                HMC.INSTANCE.supportedStatus = new HashSet();
                HMC.INSTANCE.supportedStatus.add(Status.OPERATING);
                HMC.INSTANCE.supportedStatus.add(Status.NOT_OPERATING);
                HMC.INSTANCE.acceptableStatus = new HashSet();
                HMC.INSTANCE.acceptableStatus.add(Status.OPERATING);
                HMC.INSTANCE.status = Status.OPERATING;
                HMC.INSTANCE.uiInfo = HMC.buildUIInfo();
                NetworkSettingsChangedManager nsMgr = NetworkSettingsChangedManager.getNetworkSettingsChangedManager();
                nsMgr.addNetworkSettingsChangedEventListener(INSTANCE);
                ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
                mom.addSkipPermission(INSTANCE.getObjectId());
                mom.add(INSTANCE);
                try {
                    byte[] xcpxStatus = SimServer.getSimServer().readSim(5);
                    if (xcpxStatus[0] == 4) {
                        INSTANCE.getVpdInfo(0);
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "[HMC] Exception " + e + " trying to cache VPD MTMS information");
                }
                Trace.trace(TRACE_MASKT, "[HMC] << getHMC()");
            }
        }
        return INSTANCE;
    }

    public void addAttention(Attention attn) {
        Trace.trace(TRACE_MASKT, "[HMC] >> addAttention()");
        super.addAttention(attn);
        this.addPersistedAttention(attn);
        Trace.trace(TRACE_MASKT, "[HMC] << addAttention()");
    }

    public void addAttentions(Collection attns) {
        Trace.trace(TRACE_MASKT, "[HMC] >> addAttentions()");
        super.addAttentions(attns);
        this.addPersistedAttentions(attns);
        Trace.trace(TRACE_MASKT, "[HMC] << addAttentions()");
    }

    public boolean removeAttention(Attention attn) {
        Trace.trace(TRACE_MASKT, "[HMC] >> removeAttention()");
        boolean result = super.removeAttention(attn);
        this.removePersistedAttention(attn);
        Trace.trace(TRACE_MASKT, "[HMC] << removeAttention()");
        return result;
    }

    public boolean removeAttentions(Collection attns) {
        Trace.trace(TRACE_MASKT, "[HMC] >> removeAttentions()");
        boolean result = super.removeAttentions(attns);
        this.removePersistedAttentions(attns);
        Trace.trace(TRACE_MASKT, "[HMC] << removeAttentions()");
        return result;
    }

    public void removeAllAttentions() {
        Trace.trace(TRACE_MASKT, "[HMC] >> removeAllAttentions()");
        super.removeAllAttentions();
        this.removeAllPersistedAttentions();
        Trace.trace(TRACE_MASKT, "[HMC] << removeAllAttentions()");
    }

    public Attention getAttention(AttentionID attnId) {
        Trace.trace(TRACE_MASKT, "[HMC] <> getAttention()");
        return super.getAttention(attnId);
    }

    public List getAttentions() {
        Trace.trace(TRACE_MASKT, "[HMC] <> getAttentions()");
        return super.getAttentions();
    }

    public boolean isAttentionsExist() {
        Trace.trace(TRACE_MASKT, "[HMC] <> isAttentionsExist()");
        return super.isAttentionsExist();
    }

    public String getName() {
        return (String)this.getObjectId().getKeyProperty("Name");
    }

    public LocalizableText getDisplayableName() {
        return this.getUIInfo().getUnlocalizedName();
    }

    public Scheduler getScheduler() {
        return HMCScheduler.getHMCScheduler();
    }

    public Collection getSchedulables() {
        return schedulables;
    }

    public boolean getLiccEnabled() throws HException {
        Trace.trace(TRACE_MASKT, "[HMC] >> getLiccEnabled()");
        byte[] simData = SimServer.getSimServer().readSim(21);
        boolean value = true;
        if (null == simData) {
            value = false;
            Trace.trace(TRACE_MASKF, "[HMC]    getLiccEnabled() - simData was null!!!!");
        } else {
            value = simData[0] != 0;
        }
        Trace.trace(TRACE_MASKT, "[HMC] << getLiccEnabled() - result is " + value);
        return value;
    }

    public synchronized void setLiccEnabled(boolean newValue) throws HException {
        Trace.trace(TRACE_MASKT, "[HMC] >> setLiccEnabled()");
        boolean oldValue = this.getLiccEnabled();
        Trace.trace(TRACE_MASKF, "[HMC]    setLiccEnabled() - previous value was " + oldValue);
        if (newValue == oldValue) {
            Trace.trace(TRACE_MASKF, "[HMC]    setLiccEnabled() - liccEnabled state did not change");
        } else {
            Trace.trace(TRACE_MASKF, "[HMC]    setLiccEnabled() - liccEnabled state changed to " + newValue);
            byte[] simData = new byte[]{newValue ? (byte)1 : 0};
            SimServer.getSimServer().writeSim(21, simData);
            Set towers = ManagedObjectManager.getManagedObjectManager().getInventory(new ClassId("com.ibm.hwmca.fw.managed", "Tower"));
            try {
                Iterator iterator = towers.iterator();
                while (iterator.hasNext()) {
                    Tower theTower = (Tower)iterator.next();
                    LiccEnabled theInterface = (LiccEnabled)theTower.getInterfaceImpl(class$com$ibm$hwmca$fw$updates$LiccEnabled == null ? HMC.class$("com.ibm.hwmca.fw.updates.LiccEnabled") : class$com$ibm$hwmca$fw$updates$LiccEnabled);
                    if (null == theInterface) continue;
                    Trace.trace(TRACE_MASKF, "[HMC]    setLiccEnabled() - found liccEnabled Tower: " + theTower.getUIInfo().getName());
                    theInterface.liccEnabledChanged(newValue);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_MASKT, "[HMC] << setLiccEnabled() - ");
    }

    public void setLocked(boolean locked) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        Trace.trace(TRACE_MASKT, "[HMC] >> propertyChange() : Old=" + event.getOldValue() + "  New=" + event.getNewValue());
        Trace.trace(TRACE_MASKT, "[HMC] << propertyChange()");
    }

    public String getPersistenceNameSpace() {
        return this.persistenceNameSpace;
    }

    private synchronized void readAllPersistedAttentions() {
        Trace.trace(TRACE_MASKT, "[HMC] >> readAllPersistedAttentions()");
        PersistenceManager manager = PersistenceManager.getPersistenceManager();
        List names = new ArrayList();
        try {
            names = manager.readChildrenNames(this.getPersistenceNameSpace());
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, exception);
        }
        if (names.size() > 0) {
            ArrayList<Attention> attns = new ArrayList<Attention>();
            Iterator iterator = names.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                try {
                    attns.add((Attention)manager.read(key));
                }
                catch (Exception exception) {
                    Trace.trace(TRACE_MASKF, exception);
                }
            }
            if (attns.size() > 0) {
                super.addAttentions(attns);
            }
        }
        Trace.trace(TRACE_MASKT, "[HMC] << readAllPersistedAttentions()");
    }

    private synchronized void addPersistedAttention(Attention attn) {
        Trace.trace(TRACE_MASKT, "[HMC] >> addPersistedAttention()");
        try {
            attn.persist();
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, exception);
        }
        Trace.trace(TRACE_MASKT, "[HMC] << addPersistedAttention()");
    }

    private synchronized void addPersistedAttentions(Collection attns) {
        Trace.trace(TRACE_MASKT, "[HMC] >> addPersistedAttentions()");
        Iterator iterator = attns.iterator();
        while (iterator.hasNext()) {
            this.addPersistedAttention((Attention)iterator.next());
        }
        Trace.trace(TRACE_MASKT, "[HMC] << addPersistedAttentions()");
    }

    private synchronized void removePersistedAttention(Attention attn) {
        Trace.trace(TRACE_MASKT, "[HMC] >> removePersistedAttention()");
        try {
            attn.unpersist();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKT, "[HMC] << removePersistedAttention()");
    }

    public synchronized void removePersistedAttentions(Collection attns) {
        Trace.trace(TRACE_MASKT, "[HMC] >> removePersistedAttentions()");
        Iterator iterator = attns.iterator();
        while (iterator.hasNext()) {
            this.removePersistedAttention((Attention)iterator.next());
        }
        Trace.trace(TRACE_MASKT, "[HMC] << removePersistedAttentions()");
    }

    private synchronized void removeAllPersistedAttentions() {
        Trace.trace(TRACE_MASKT, "[HMC] >> removeAllPersistedAttentions()");
        this.pm.deleteChildrenRecursive(this.getPersistenceNameSpace());
        Trace.trace(TRACE_MASKT, "[HMC] << removeAllPersistedAttentions()");
    }

    public void networkSettingsChanged(NetworkSettingsChangedEvent event) {
        String computerName;
        NetworkInfo newNetworkInfo = event.getNetworkInfo();
        if (newNetworkInfo != null && (computerName = newNetworkInfo.getComputerName()) != null && computerName.length() > 0) {
            UIInfo newUIInfo = (UIInfo)this.getUIInfo().clone();
            newUIInfo.setName(new LocalizableText(computerName));
            this.setUIInfo(newUIInfo);
        }
    }

    private static UIInfo buildUIInfo() {
        Trace.trace(TRACE_MASKF, "[HMC] -> buildUInfo");
        LocalizableText hmcText = new LocalizableText("com/ibm/hwmca/fw/res/common", "text.hwmca.name");
        String hmcName = null;
        try {
            NetworkSettings networkSettings = NetworkSettings.getNetworkSettings();
            hmcName = networkSettings.getNetworkInfo().getComputerName();
            Trace.trace(TRACE_MASKF, "[HMC] computer name is: " + hmcName);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[HMC] Exception getting computer name: " + e);
            Trace.trace(TRACE_MASKF, e);
        }
        try {
            byte[] nauByte;
            if ((hmcName == null || hmcName.length() <= 0) && (nauByte = SimServer.getSimServer().readSim(7)) != null && nauByte.length > 0) {
                int len;
                for (len = 0; nauByte[len] != 0 && len < nauByte.length; ++len) {
                }
                hmcName = new String(nauByte, 0, len);
                Trace.trace(TRACE_MASKF, "[HMC] name from SIM is: " + hmcName);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[HMC] Exception getting name from SIM: " + e);
            Trace.trace(TRACE_MASKF, e);
        }
        if (hmcName == null || hmcName.length() <= 0) {
            hmcName = "HMC";
        }
        Trace.trace(TRACE_MASKF, "[HMC] using HMC name of: " + hmcName);
        UIInfo uiInfo = new UIInfo(new LocalizableText(hmcName), hmcText, "com/ibm/hwmca/fw/images/consact.gif", "com/ibm/hwmca/fw/images/consact.gif", hmcText);
        uiInfo.setImageURL("/fw/consact.gif");
        Trace.trace(TRACE_MASKF, "[HMC] <- buildUInfo");
        return uiInfo;
    }

    public String getMachineType() {
        return this.getVpdInfo(1);
    }

    public String getMachineModel() {
        return this.getVpdInfo(2);
    }

    public String getMachineSerial() {
        return this.getVpdInfo(3);
    }

    public boolean isPersistent() {
        return false;
    }

    public PersistentData getPersistentData() {
        throw new UnsupportedOperationException("getPersistentData() : The HMC is not persistable");
    }

    public final Object writeObject(Object object) throws IOException {
        throw new NotSerializableException("writeObject() : The HMC is not serializable");
    }

    private Object readResolve() {
        return HMC.getHMC();
    }

    private String getVpdInfo(int field) {
        Trace.trace(TRACE_MASKF, "[HMC] -> getVpdInfo(" + field + ")");
        String value = "";
        if (field == 1 || field == 2 || field == 0 || field == 3) {
            try {
                VpdConfigurationData machData = null;
                if (!this.bCacheMtms) {
                    VpdManager vpdManager = VpdManager.getVpdManager();
                    VpdData vpdConfigData = new VpdData(VpdRequestValue.CONFIG_REQUEST);
                    vpdConfigData = vpdManager.callVpdManager(vpdConfigData);
                    machData = vpdConfigData.getVpdConfigurationExistData();
                    Trace.trace(TRACE_MASKF, "machine model is: " + machData.getMachineModel());
                    Trace.trace(TRACE_MASKF, "machine type is: " + machData.getMachineType());
                    Trace.trace(TRACE_MASKF, "machine serial is: " + machData.getMachineSerial());
                } else {
                    Trace.trace(TRACE_MASKF, "machine model is: " + this.machineModel);
                    Trace.trace(TRACE_MASKF, "machine type is: " + this.machineType);
                    Trace.trace(TRACE_MASKF, "machine serial is: " + this.machineSerial);
                }
                switch (field) {
                    case 1: {
                        if (this.bCacheMtms) {
                            value = this.machineType;
                            break;
                        }
                        value = machData.getMachineType();
                        break;
                    }
                    case 2: {
                        if (this.bCacheMtms) {
                            value = this.machineModel;
                            break;
                        }
                        value = machData.getMachineModel();
                        break;
                    }
                    case 3: {
                        if (this.bCacheMtms) {
                            value = this.machineSerial;
                            break;
                        }
                        value = machData.getMachineSerial();
                        break;
                    }
                    case 0: {
                        this.machineType = machData.getMachineType();
                        this.machineModel = machData.getMachineModel();
                        this.machineSerial = machData.getMachineSerial();
                        Trace.trace(TRACE_MASKF, "[HMC] VPD MTMS information is now cached.");
                        this.bCacheMtms = true;
                    }
                }
            }
            catch (VpdManagerException e) {
                Trace.trace(TRACE_MASKF, "Exception caught making VPD calls.");
                Trace.trace(TRACE_MASKF, e);
            }
        } else {
            throw new IllegalArgumentException("Invalid VPD field specified.");
        }
        Trace.trace(TRACE_MASKF, "[HMC] <- getVpdInfo(" + value + ")");
        return value;
    }

    public static String getTitle() {
        Trace.trace(TRACE_MASKF, "[HMC] -> getTitle");
        String title = "";
        try {
            CommonSystem sys = CommonSystem.getCommonSystem();
            if (sys.isLocationServer() || sys.isLocationUnified()) {
                Trace.trace(TRACE_MASKF, "[HMC] location is server or unified so using HMC object");
                title = HMC.getHMC().getUIInfo().getTitle();
            } else {
                Trace.trace(TRACE_MASKF, "[HMC] location is NOT server or unified so using non panel tasklet");
                Client authClient = new Client("com.ibm.hwmca.fw.servlet.support.SupportAuthTasklet", null);
                TaskletResponse resp = authClient.init();
                String tmpTitle = (String)resp.getData("title");
                if (tmpTitle != null) {
                    title = tmpTitle;
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKF, "[HMC] <- getTitle");
        return title;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        initializeLock = new Object();
        schedulables = null;
    }

    public static final class Init
    implements Runnable {
        public void run() {
            Trace.trace(HMC.TRACE_MASKT, "-> HMC#Init.run()");
            try {
                HMC.getHMC();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Trace.trace(HMC.TRACE_MASKT, "<- HMC#Init.run()");
        }
    }
}

